<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://simplescon.com');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Configurações da API
define('API_BASE_URL', 'https://pierpublic.azurewebsites.net');
define('AUTH_URL', API_BASE_URL . '/login/validar');
define('API_URL', API_BASE_URL . '/solicitacao/abertura/abrirchamado');
define('API_USER', 'robson@simplescon.com');
define('API_PASS', 'Crasso00+');

// Função para autenticação
function getAuthToken() {
    $authUrl = AUTH_URL . '?' . http_build_query([
        'login' => API_USER,
        'senha' => API_PASS
    ]);
    
    $ch = curl_init($authUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['Accept: application/json'],
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => true
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (!$response || $httpCode !== 200) {
        return false;
    }

    $data = json_decode($response, true);
    return $data['token'] ?? false;
}

// Função para formatar os dados do formulário
function formatarObservacoes($formData) {
    return "DADOS DO SOLICITANTE:
• Nome Completo: {$formData['nome']}
• CPF: {$formData['cpf']}
• E-mail: {$formData['email']}
• Telefone: {$formData['telefone']}

ENDEREÇO:
• CEP: {$formData['cep']}
• Logradouro: {$formData['logradouro']}
• Número: {$formData['numero']}
• Complemento: {$formData['complemento'] ?? 'Não informado'}
• Bairro: {$formData['bairro']}
• Cidade: {$formData['cidade']}
• Estado: {$formData['estado']}

DADOS DA EMPRESA:
• Nome da Empresa: {$formData['nome_empresa']}
• Tipo de Empresa: {$formData['tipo_empresa']}
• CNAE Principal: {$formData['cnae_principal']}
• Capital Social: R$ {$formData['capital_social']}

DESCRIÇÃO DAS ATIVIDADES:
{$formData['descricao_atividades']}

OBSERVAÇÕES ADICIONAIS:
{$formData['observacoes_adicionais'] ?? 'Nenhuma observação adicional'}";
}

try {
    // Verificar método HTTP
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método não permitido', 405);
    }

    // Obter dados do formulário
    $input = file_get_contents('php://input');
    $requestData = json_decode($input, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Formato JSON inválido', 400);
    }

    // Validar campos obrigatórios (sem o campo 'texto')
    $requiredFields = ['cliente_id', 'tiposolicitacao_id', 'responsavel_id', 'assunto', 'observacoes'];
    foreach ($requiredFields as $field) {
        if (!isset($requestData[$field])) {
            throw new Exception("Campo obrigatório faltando: $field", 400);
        }
    }

    // Obter token de autenticação
    $token = getAuthToken();
    if (!$token) {
        throw new Exception('Falha na autenticação com a API PIER', 401);
    }

    // Preparar parâmetros para GET
    $queryParams = http_build_query([
        'cliente_id' => $requestData['cliente_id'],
        'tiposolicitacao_id' => $requestData['tiposolicitacao_id'],
        'responsavel_id' => $requestData['responsavel_id'],
        'assunto' => $requestData['assunto'],
        'observacoes' => formatarObservacoes($requestData)
    ]);

    // Configurar requisição GET
    $ch = curl_init(API_URL . '?' . $queryParams);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $token,
            'Accept: application/json'
        ],
        CURLOPT_TIMEOUT => 15,
        CURLOPT_SSL_VERIFYPEER => true
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        throw new Exception('Erro na conexão: ' . curl_error($ch), 500);
    }

    curl_close($ch);

    // Verificar resposta
    $responseData = json_decode($response, true);
    if ($httpCode !== 200) {
        $errorMsg = $responseData['message'] ?? 'Erro na API PIER';
        throw new Exception($errorMsg, $httpCode);
    }

    // Retornar resposta de sucesso
    echo json_encode([
        'success' => true,
        'protocolo' => $responseData['protocolo'] ?? 'N/A',
        'message' => 'Solicitação enviada com sucesso'
    ]);

} catch (Exception $e) {
    http_response_code($e->getCode() >= 400 ? $e->getCode() : 500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'code' => $e->getCode()
    ]);
}
?>