# Documentação do Formulário de Integração com API PIER

## Visão Geral

Este documento descreve o formulário web desenvolvido para coletar dados de abertura de empresa e enviá-los para a API do PIER. O formulário possui múltiplas etapas, validações de campos e integração com a API conforme os requisitos especificados.

## Estrutura do Projeto

```
formulario-pier/
├── index.html      # Arquivo principal do formulário
├── css/
│   └── styles.css  # Estilos do formulário
└── js/
    └── script.js   # Lógica de funcionamento e integração
```

## Funcionalidades Implementadas

1. **Formulário de Múltiplas Etapas**
   - Etapa 1: Dados Pessoais (nome, CPF, e-mail, telefone)
   - Etapa 2: Endereço (CEP, logradouro, número, complemento, bairro, cidade, estado)
   - Etapa 3: Dados da Empresa (nome, tipo, CNAE, capital social)
   - Etapa 4: Informações Adicionais (descrição de atividades, observações)

2. **Validações de Campos**
   - Validação de campos obrigatórios
   - Máscaras para CPF, telefone, CEP e valores monetários
   - Busca automática de endereço pelo CEP

3. **Integração com API PIER**
   - Endpoint: POST /solicitacao/postar
   - Parâmetros obrigatórios: solicitacao_id e texto
   - Dados fixos conforme requisitos:
     - cliente_id=00122175
     - tiposolicitacao_id=0010b5bd
     - responsavel_id=000fba73
     - assunto=Nova Abertura de Empresa pelo Site
     - observacoes=Dados preenchido pelo leed no site

4. **Feedback ao Usuário**
   - Mensagens de sucesso com número de protocolo
   - Mensagens de erro com opção de tentar novamente

## Detalhes da Integração com a API PIER

### Autenticação

Para integrar com a API do PIER em ambiente de produção, é necessário:

1. Obter token de autenticação via endpoint `/login/validar`
2. Configurar o cabeçalho Authorization com `Bearer + token`
3. Fazer a requisição POST para `/solicitacao/postar`

### Payload da Requisição

O payload enviado para a API segue o formato:

```json
{
  "solicitacao_id": "00122175",
  "texto": "Conteúdo formatado com todos os dados do formulário"
}
```

O campo `texto` é montado dinamicamente com todos os dados preenchidos no formulário, incluindo os dados fixos especificados nos requisitos.

## Instruções para Implementação em Produção

### 1. Configuração da Autenticação

No arquivo `js/script.js`, localize a função `enviarParaAPIPier` e descomente o código de implementação real, substituindo as credenciais de autenticação conforme necessário.

### 2. Ajustes de URL da API

Verifique se a URL base da API está correta:
```javascript
const API_BASE_URL = 'https://pierpublic.azurewebsites.net';
```

### 3. Testes em Produção

Antes de disponibilizar o formulário para uso público, realize testes completos em ambiente de produção para garantir que:
- A autenticação está funcionando corretamente
- Os dados estão sendo enviados no formato esperado
- As respostas da API estão sendo tratadas adequadamente

## Personalização

### Estilos

Os estilos do formulário podem ser personalizados editando o arquivo `css/styles.css`. As cores principais já estão definidas como variáveis CSS:

```css
:root {
    --primary-color: #f45720;
    --secondary-color: #5ca6ce;
    --accent-color: #e7eacb;
    --success-color: #78c753;
    --dark-color: #1f495b;
}
```

### Campos do Formulário

Para adicionar, remover ou modificar campos, edite o arquivo `index.html` e atualize a lógica correspondente no arquivo `js/script.js`.

## Considerações de Segurança

- Implemente HTTPS para proteger os dados transmitidos
- Considere adicionar proteção contra CSRF (Cross-Site Request Forgery)
- Implemente rate limiting para prevenir abusos
- Armazene credenciais de API em variáveis de ambiente, não no código-fonte

## Suporte e Manutenção

Para suporte ou dúvidas sobre a implementação, entre em contato com a equipe de desenvolvimento.
