<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://contratar.simplescon.com');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Configurações da API
define('API_BASE_URL', 'https://pierpublic.azurewebsites.net');
define('AUTH_URL', API_BASE_URL . '/login/validar');
define('API_URL', API_BASE_URL . '/solicitacao/abertura/abrirchamado');
define('API_USER', 'robson@simplescon.com');
define('API_PASS', 'Crasso00+');

// Função para autenticação
function getAuthToken() {
    $authUrl = AUTH_URL . '?' . http_build_query([
        'login' => API_USER,
        'senha' => API_PASS
    ]);
    
    $ch = curl_init($authUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['Accept: application/json'],
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => true
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        throw new Exception('Erro na autenticação: ' . curl_error($ch));
    }

    if ($httpCode !== 200) {
        throw new Exception('Falha na autenticação. Código HTTP: ' . $httpCode);
    }

    $data = json_decode($response, true);
    if (!$data || !isset($data['token'])) {
        throw new Exception('Token não recebido na resposta');
    }

    return $data['token'];
}

try {
    // Verificar método HTTP
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        exit(0);
    }

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método não permitido', 405);
    }

    // Obter dados do formulário
    $input = file_get_contents('php://input');
    $requestData = json_decode($input, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Formato JSON inválido', 400);
    }

    // Validar campos obrigatórios
    $requiredFields = ['cliente_id', 'tiposolicitacao_id', 'responsavel_id', 'assunto', 'observacoes'];
    foreach ($requiredFields as $field) {
        if (empty($requestData[$field])) {
            throw new Exception("Campo obrigatório faltando: $field", 400);
        }
    }

    // Obter token de autenticação
    $token = getAuthToken();

    // Preparar requisição para a API PIER (GET com parâmetros na URL)
    $queryParams = http_build_query([
        'cliente_id' => $requestData['cliente_id'],
        'tiposolicitacao_id' => $requestData['tiposolicitacao_id'],
        'responsavel_id' => $requestData['responsavel_id'],
        'assunto' => $requestData['assunto'],
        'observacoes' => $requestData['observacoes']
    ]);

    $apiUrl = API_URL . '?' . $queryParams;

    $ch = curl_init($apiUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $token,
            'Accept: application/json'
        ],
        CURLOPT_TIMEOUT => 15,
        CURLOPT_SSL_VERIFYPEER => true
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    if ($error) {
        throw new Exception('Erro na conexão com a API PIER: ' . $error, 500);
    }

    if ($httpCode !== 200) {
        $responseData = json_decode($response, true);
        $errorMsg = $responseData['message'] ?? 'Erro na API PIER';
        throw new Exception($errorMsg, $httpCode);
    }

    // Retornar resposta de sucesso
    echo json_encode([
        'success' => true,
        'protocolo' => $responseData['protocolo'] ?? 'N/A',
        'message' => 'Solicitação enviada com sucesso'
    ]);

} catch (Exception $e) {
    http_response_code($e->getCode() >= 400 ? $e->getCode() : 500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'code' => $e->getCode(),
        'details' => isset($apiUrl) ? ['api_url' => $apiUrl] : null
    ]);
}
?>